/************************************************************************
 * \file: iap2_calculate_parameter_length.h
 *
 * \version: $ $
 *
 * This header file declares functions required for calculating the length of the parameter.
 *
 * \component: global definition file
 *
 * \author: Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright: (c) 2010 - 2016 ADIT Corporation
 *
 * CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_CALCULATE_PARAMETER_LENGTH_H
#define IAP2_CALCULATE_PARAMETER_LENGTH_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup CalculateParameterLength
 * @{
 */

 /***************************************************************************//**
 * Calculates the length of the AccessoryAuthenticationSerialNumberParameter
 * 
 * \param[in]  paramStructure Structure holding information about AccessoryAuthenticationSerialNumberParameter, for which the length has to be calculated, it should be of type iAP2AccessoryAuthenticationSerialNumberParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AccessoryAuthenticationSerialNumberParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the AuthenticationCertificateParameter
 * 
 * \param[in]  paramStructure Structure holding information about AuthenticationCertificateParameter, for which the length has to be calculated, it should be of type iAP2AuthenticationCertificateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AuthenticationCertificateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the AuthenticationResponseParameter
 * 
 * \param[in]  paramStructure Structure holding information about AuthenticationResponseParameter, for which the length has to be calculated, it should be of type iAP2AuthenticationResponseParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AuthenticationResponseParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the IdentificationInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about IdentificationInformationParameter, for which the length has to be calculated, it should be of type iAP2IdentificationInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2IdentificationInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the IdentificationInformationUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about IdentificationInformationUpdateParameter, for which the length has to be calculated, it should be of type iAP2IdentificationInformationUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2IdentificationInformationUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestAppLaunchParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestAppLaunchParameter, for which the length has to be calculated, it should be of type iAP2RequestAppLaunchParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestAppLaunchParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the OOBBTPairingAccessoryInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about OOBBTPairingAccessoryInformationParameter, for which the length has to be calculated, it should be of type iAP2OOBBTPairingAccessoryInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2OOBBTPairingAccessoryInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the OOBBTPairingCompletionInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about OOBBTPairingCompletionInformationParameter, for which the length has to be calculated, it should be of type iAP2OOBBTPairingCompletionInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2OOBBTPairingCompletionInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartRouteGuidanceUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartRouteGuidanceUpdateParameter, for which the length has to be calculated, it should be of type iAP2StartRouteGuidanceUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartRouteGuidanceUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StopRouteGuidanceUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about StopRouteGuidanceUpdateParameter, for which the length has to be calculated, it should be of type iAP2StopRouteGuidanceUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StopRouteGuidanceUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the BluetoothComponentInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about BluetoothComponentInformationParameter, for which the length has to be calculated, it should be of type iAP2BluetoothComponentInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2BluetoothComponentInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartBluetoothConnectionUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartBluetoothConnectionUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartBluetoothConnectionUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartBluetoothConnectionUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the AcceptCallParameter
 * 
 * \param[in]  paramStructure Structure holding information about AcceptCallParameter, for which the length has to be calculated, it should be of type iAP2AcceptCallParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AcceptCallParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the EndCallParameter
 * 
 * \param[in]  paramStructure Structure holding information about EndCallParameter, for which the length has to be calculated, it should be of type iAP2EndCallParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2EndCallParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the HoldStatusUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about HoldStatusUpdateParameter, for which the length has to be calculated, it should be of type iAP2HoldStatusUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2HoldStatusUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the InitiateCallParameter
 * 
 * \param[in]  paramStructure Structure holding information about InitiateCallParameter, for which the length has to be calculated, it should be of type iAP2InitiateCallParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2InitiateCallParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the MuteStatusUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about MuteStatusUpdateParameter, for which the length has to be calculated, it should be of type iAP2MuteStatusUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2MuteStatusUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the SendDTMFParameter
 * 
 * \param[in]  paramStructure Structure holding information about SendDTMFParameter, for which the length has to be calculated, it should be of type iAP2SendDTMFParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2SendDTMFParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartCallStateUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartCallStateUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartCallStateUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartCallStateUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartCommunicationsUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartCommunicationsUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartCommunicationsUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartCommunicationsUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartListUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartListUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartListUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartListUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestDeviceAuthenticationChallengeResponseParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestDeviceAuthenticationChallengeResponseParameter, for which the length has to be calculated, it should be of type iAP2RequestDeviceAuthenticationChallengeResponseParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestDeviceAuthenticationChallengeResponseParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StatusExternalAccessoryProtocolSessionParameter
 * 
 * \param[in]  paramStructure Structure holding information about StatusExternalAccessoryProtocolSessionParameter, for which the length has to be calculated, it should be of type iAP2StatusExternalAccessoryProtocolSessionParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StatusExternalAccessoryProtocolSessionParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the AccessoryHIDReportParameter
 * 
 * \param[in]  paramStructure Structure holding information about AccessoryHIDReportParameter, for which the length has to be calculated, it should be of type iAP2AccessoryHIDReportParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AccessoryHIDReportParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartHIDParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartHIDParameter, for which the length has to be calculated, it should be of type iAP2StartHIDParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartHIDParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StopHIDParameter
 * 
 * \param[in]  paramStructure Structure holding information about StopHIDParameter, for which the length has to be calculated, it should be of type iAP2StopHIDParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StopHIDParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the LocationInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about LocationInformationParameter, for which the length has to be calculated, it should be of type iAP2LocationInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2LocationInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PlayMediaLibraryCollectionParameter
 * 
 * \param[in]  paramStructure Structure holding information about PlayMediaLibraryCollectionParameter, for which the length has to be calculated, it should be of type iAP2PlayMediaLibraryCollectionParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PlayMediaLibraryCollectionParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PlayMediaLibraryCurrentSelectionParameter
 * 
 * \param[in]  paramStructure Structure holding information about PlayMediaLibraryCurrentSelectionParameter, for which the length has to be calculated, it should be of type iAP2PlayMediaLibraryCurrentSelectionParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PlayMediaLibraryCurrentSelectionParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PlayMediaLibraryItemsParameter
 * 
 * \param[in]  paramStructure Structure holding information about PlayMediaLibraryItemsParameter, for which the length has to be calculated, it should be of type iAP2PlayMediaLibraryItemsParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PlayMediaLibraryItemsParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PlayMediaLibrarySpecialParameter
 * 
 * \param[in]  paramStructure Structure holding information about PlayMediaLibrarySpecialParameter, for which the length has to be calculated, it should be of type iAP2PlayMediaLibrarySpecialParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PlayMediaLibrarySpecialParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartMediaLibraryUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartMediaLibraryUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartMediaLibraryUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartMediaLibraryUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StopMediaLibraryUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StopMediaLibraryUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StopMediaLibraryUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StopMediaLibraryUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the SetNowPlayingInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about SetNowPlayingInformationParameter, for which the length has to be calculated, it should be of type iAP2SetNowPlayingInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2SetNowPlayingInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartNowPlayingUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartNowPlayingUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartNowPlayingUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartNowPlayingUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PowerSourceUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about PowerSourceUpdateParameter, for which the length has to be calculated, it should be of type iAP2PowerSourceUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PowerSourceUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartPowerUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartPowerUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartPowerUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartPowerUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartTelephonyCallStateInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartTelephonyCallStateInformationParameter, for which the length has to be calculated, it should be of type iAP2StartTelephonyCallStateInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartTelephonyCallStateInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartTelephonyUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartTelephonyUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartTelephonyUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartTelephonyUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the VehicleStatusUpdateParameter
 * 
 * \param[in]  paramStructure Structure holding information about VehicleStatusUpdateParameter, for which the length has to be calculated, it should be of type iAP2VehicleStatusUpdateParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2VehicleStatusUpdateParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestVoiceOverConfigurationParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestVoiceOverConfigurationParameter, for which the length has to be calculated, it should be of type iAP2RequestVoiceOverConfigurationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestVoiceOverConfigurationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestVoiceOverMoveCursorParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestVoiceOverMoveCursorParameter, for which the length has to be calculated, it should be of type iAP2RequestVoiceOverMoveCursorParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestVoiceOverMoveCursorParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestVoiceOverScrollPageParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestVoiceOverScrollPageParameter, for which the length has to be calculated, it should be of type iAP2RequestVoiceOverScrollPageParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestVoiceOverScrollPageParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RequestVoiceOverSpeakTextParameter
 * 
 * \param[in]  paramStructure Structure holding information about RequestVoiceOverSpeakTextParameter, for which the length has to be calculated, it should be of type iAP2RequestVoiceOverSpeakTextParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RequestVoiceOverSpeakTextParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartVoiceOverCursorUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartVoiceOverCursorUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartVoiceOverCursorUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartVoiceOverCursorUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartVoiceOverUpdatesParameter
 * 
 * \param[in]  paramStructure Structure holding information about StartVoiceOverUpdatesParameter, for which the length has to be calculated, it should be of type iAP2StartVoiceOverUpdatesParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartVoiceOverUpdatesParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the AccessoryWiFiConfigurationInformationParameter
 * 
 * \param[in]  paramStructure Structure holding information about AccessoryWiFiConfigurationInformationParameter, for which the length has to be calculated, it should be of type iAP2AccessoryWiFiConfigurationInformationParameter.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2AccessoryWiFiConfigurationInformationParameter(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the BluetoothComponentStatus
 * 
 * \param[in]  paramStructure Structure holding information about BluetoothComponentStatus, for which the length has to be calculated, it should be of type iAP2BluetoothComponentStatus.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2BluetoothComponentStatus(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the BluetoothHIDComponent
 * 
 * \param[in]  paramStructure Structure holding information about BluetoothHIDComponent, for which the length has to be calculated, it should be of type iAP2BluetoothHIDComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2BluetoothHIDComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the BluetoothTransportComponent
 * 
 * \param[in]  paramStructure Structure holding information about BluetoothTransportComponent, for which the length has to be calculated, it should be of type iAP2BluetoothTransportComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2BluetoothTransportComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the ExternalAccessoryProtocol
 * 
 * \param[in]  paramStructure Structure holding information about ExternalAccessoryProtocol, for which the length has to be calculated, it should be of type iAP2ExternalAccessoryProtocol.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2ExternalAccessoryProtocol(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the FavoritesListProperties
 * 
 * \param[in]  paramStructure Structure holding information about FavoritesListProperties, for which the length has to be calculated, it should be of type iAP2FavoritesListProperties.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2FavoritesListProperties(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the iAP2HIDComponent
 * 
 * \param[in]  paramStructure Structure holding information about iAP2HIDComponent, for which the length has to be calculated, it should be of type iAP2iAP2HIDComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2iAP2HIDComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the LocationInformationComponent
 * 
 * \param[in]  paramStructure Structure holding information about LocationInformationComponent, for which the length has to be calculated, it should be of type iAP2LocationInformationComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2LocationInformationComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the MediaItemAttributes
 * 
 * \param[in]  paramStructure Structure holding information about MediaItemAttributes, for which the length has to be calculated, it should be of type iAP2MediaItemAttributes.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2MediaItemAttributes(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the MediaItemProperties
 * 
 * \param[in]  paramStructure Structure holding information about MediaItemProperties, for which the length has to be calculated, it should be of type iAP2MediaItemProperties.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2MediaItemProperties(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the MediaPlaylistContentTransferInfoRequest
 * 
 * \param[in]  paramStructure Structure holding information about MediaPlaylistContentTransferInfoRequest, for which the length has to be calculated, it should be of type iAP2MediaPlaylistContentTransferInfoRequest.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2MediaPlaylistContentTransferInfoRequest(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the MediaPlaylistProperties
 * 
 * \param[in]  paramStructure Structure holding information about MediaPlaylistProperties, for which the length has to be calculated, it should be of type iAP2MediaPlaylistProperties.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2MediaPlaylistProperties(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the PlaybackQueueListContentTransferInfoRequest
 * 
 * \param[in]  paramStructure Structure holding information about PlaybackQueueListContentTransferInfoRequest, for which the length has to be calculated, it should be of type iAP2PlaybackQueueListContentTransferInfoRequest.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2PlaybackQueueListContentTransferInfoRequest(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RecentsListProperties
 * 
 * \param[in]  paramStructure Structure holding information about RecentsListProperties, for which the length has to be calculated, it should be of type iAP2RecentsListProperties.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RecentsListProperties(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the RouteGuidanceDisplayComponent
 * 
 * \param[in]  paramStructure Structure holding information about RouteGuidanceDisplayComponent, for which the length has to be calculated, it should be of type iAP2RouteGuidanceDisplayComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2RouteGuidanceDisplayComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the SerialTransportComponent
 * 
 * \param[in]  paramStructure Structure holding information about SerialTransportComponent, for which the length has to be calculated, it should be of type iAP2SerialTransportComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2SerialTransportComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the StartNowPlayingPlaybackAttributes
 * 
 * \param[in]  paramStructure Structure holding information about StartNowPlayingPlaybackAttributes, for which the length has to be calculated, it should be of type iAP2StartNowPlayingPlaybackAttributes.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2StartNowPlayingPlaybackAttributes(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the USBDeviceTransportComponent
 * 
 * \param[in]  paramStructure Structure holding information about USBDeviceTransportComponent, for which the length has to be calculated, it should be of type iAP2USBDeviceTransportComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2USBDeviceTransportComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the USBHostHIDComponent
 * 
 * \param[in]  paramStructure Structure holding information about USBHostHIDComponent, for which the length has to be calculated, it should be of type iAP2USBHostHIDComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2USBHostHIDComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the USBHostTransportComponent
 * 
 * \param[in]  paramStructure Structure holding information about USBHostTransportComponent, for which the length has to be calculated, it should be of type iAP2USBHostTransportComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2USBHostTransportComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the VehicleInformationComponent
 * 
 * \param[in]  paramStructure Structure holding information about VehicleInformationComponent, for which the length has to be calculated, it should be of type iAP2VehicleInformationComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2VehicleInformationComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the VehicleStatusComponent
 * 
 * \param[in]  paramStructure Structure holding information about VehicleStatusComponent, for which the length has to be calculated, it should be of type iAP2VehicleStatusComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2VehicleStatusComponent(const void* paramStructure, U16* parameterLength);

 /***************************************************************************//**
 * Calculates the length of the WirelessCarPlayTransportComponent
 * 
 * \param[in]  paramStructure Structure holding information about WirelessCarPlayTransportComponent, for which the length has to be calculated, it should be of type iAP2WirelessCarPlayTransportComponent.
 * \param[out] parameterLength  Variable in which the calculated length has to be stored.
 * 
 * \return IAP2_OK  On Successful completion of calculating the length.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ********************************************************************************/
S32 iAP2CalcLengthiAP2WirelessCarPlayTransportComponent(const void* paramStructure, U16* parameterLength);

/** @} */

#ifdef __cplusplus
}
#endif

#endif
